/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertPrincipal;
import com.ibm.hwmca.fw.certs.CertSignReq;
import com.ibm.hwmca.fw.certs.CertUtils;
import com.ibm.hwmca.fw.certs.SubjectAltNames;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.security.auth.x500.X500Principal;

class ServerCert
implements Serializable,
CertMgtConstants {
    public static final int RETURN_OK = 0;
    public static final int RETURN_INVALID_NUM_OF_ARGS = 16;
    public static final int RETURN_EXCEPTION = 32;
    public static final int RETURN_INSUFFICIENT = 48;
    public static final int RETURN_EXTRANEOUS = 64;
    public static final int RETURN_UNKNOWN = 80;
    private static final String VIEW_PARM = "view";
    private static final String INSTALL_PARM = "install";
    private static final String TRACE_MASKD = "XCRTSRVD";
    private static final String TRACE_MASKF = "XCRTSRVF";
    private static final String TRACE_MASKT = "XCRTSRVT";
    private Integer days = null;
    private Date validFrom = null;
    private Date validTill = null;
    private CertPrincipal issuer = null;
    private CertPrincipal subject = null;
    private SubjectAltNames alternativeNames = null;
    private int version = -1;
    private BigInteger serialNumber = null;
    private boolean isForCA = false;

    protected ServerCert(int days, String country, String state, String locality, String org, String orgUnit, String hostName, String eMailAddr, CertPrincipal issuer, HashSet alternateDNSNames, HashSet ipAddresses, boolean isForCA) {
        GregorianCalendar calendar = null;
        if (days < 1) {
            throw new IllegalArgumentException("days can not be less than 1: " + days);
        }
        this.days = new Integer(days);
        calendar = new GregorianCalendar();
        this.subject = new CertPrincipal(country, state, locality, org, orgUnit, hostName, eMailAddr);
        this.issuer = issuer;
        this.alternativeNames = new SubjectAltNames(alternateDNSNames == null ? new HashSet() : alternateDNSNames, ipAddresses == null ? new HashSet() : ipAddresses);
        this.isForCA = isForCA;
        Trace.trace(TRACE_MASKT, "<->ServerCert(" + days + ", " + country + ", " + state + ", " + locality + ", " + org + ", " + orgUnit + ", " + hostName + ", " + eMailAddr + ", ..., " + isForCA + ")");
    }

    ServerCert(X509Certificate certificate) throws HException {
        Object subjectAltNames = null;
        Object subject = null;
        X500Principal tempIssuer = null;
        if (certificate != null) {
            this.parse(certificate.getSubjectX500Principal());
            this.validFrom = certificate.getNotBefore();
            this.validTill = certificate.getNotAfter();
            this.alternativeNames = new SubjectAltNames(certificate);
            tempIssuer = certificate.getIssuerX500Principal();
            Trace.trace(TRACE_MASKD, "issuer found of " + tempIssuer);
            this.issuer = tempIssuer != null ? new CertPrincipal(tempIssuer) : null;
            this.version = certificate.getVersion();
            this.serialNumber = certificate.getSerialNumber();
        }
        Trace.trace(TRACE_MASKD, "->ServerCert constructed of " + this);
        Trace.trace(TRACE_MASKT, "<->ServerCert(" + certificate + ")");
    }

    ServerCert(String fileName) throws HException, FileNotFoundException {
        this(CertUtils.createX509Certificate(fileName));
    }

    ServerCert(ServerCert certToClone) {
        if (certToClone != null) {
            this.days = certToClone.days != null ? new Integer(certToClone.days) : null;
            this.validFrom = certToClone.validFrom != null ? new Date(certToClone.validFrom.getTime()) : null;
            this.validTill = certToClone.validTill != null ? new Date(certToClone.validTill.getTime()) : null;
            this.issuer = certToClone.issuer != null ? new CertPrincipal(certToClone.issuer) : null;
            this.subject = certToClone.subject != null ? new CertPrincipal(certToClone.subject) : null;
            this.alternativeNames = certToClone.alternativeNames != null ? new SubjectAltNames(certToClone.alternativeNames) : null;
            this.version = certToClone.version;
            this.serialNumber = certToClone.serialNumber;
            this.isForCA = certToClone.isForCA;
        }
    }

    public static void main(String[] args) {
        StringBuffer argsLine = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            argsLine.append(' ');
            argsLine.append(args[i]);
        }
        Trace.trace(TRACE_MASKD, "main() called with the following parameters :" + argsLine.toString());
        if (args.length == 0) {
            ServerCert.displayHelp();
            CertUtils.doExit(49);
        }
        try {
            if (args[0].equalsIgnoreCase(VIEW_PARM)) {
                if (args.length < 2) {
                    ServerCert.displayHelp();
                    CertUtils.doExit(48 + args.length + 1);
                } else if (args.length > 2) {
                    ServerCert.displayHelp();
                    CertUtils.doExit(67);
                }
                ServerCert.view(args[1]);
            } else if (args[0].equalsIgnoreCase(INSTALL_PARM)) {
                if (args.length < 3) {
                    ServerCert.displayHelp();
                    CertUtils.doExit(48 + args.length + 1);
                } else if (args.length > 3) {
                    ServerCert.displayHelp();
                    CertUtils.doExit(68);
                }
                CertUtils.install(args[1], args[2], null, false, false, null);
            } else {
                CertUtils.doExit(81);
            }
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKD, e);
            e.printStackTrace();
            CertUtils.doExit(32);
        }
        catch (FileNotFoundException e) {
            Trace.trace(TRACE_MASKD, e);
            e.printStackTrace();
            CertUtils.doExit(32);
        }
        CertUtils.doExit(0);
    }

    private static void displayHelp() {
        System.out.println("Usage : 'java' 'com.ibm.hwmca.fw.certs.ServerCert' 'view' serverCertFileToView");
        System.out.println("");
        System.out.println("serverCertFileToView is the fully qualified name of the server certificate file to view.");
        System.out.println("");
        System.out.println("A return code other than 0 indicates an error.");
        System.out.println("");
        System.out.println(" or ");
        System.out.println("");
        System.out.println("Usage : 'java' 'com.ibm.hwmca.fw.certs.ServerCert' 'install' serverCertFileToInstall serverkKeyFileToInstall");
        System.out.println("");
        System.out.println("serverCertFileToInstall is the fully qualified name of the server certificate file to install.");
        System.out.println("serverKeyFileToInstall is the fully qualified name of the server key file to install.");
        System.out.println("");
        System.out.println("A return code other than 0 indicates an error.");
        System.out.println("");
        System.out.println("The above command syntax above uses the following conventions:");
        System.out.println("");
        System.out.println("Literal tokens in the specified command are denoted by being enclosed in single quotes.");
        System.out.println("When specified, the single quotes should not be specified.");
        System.out.println("");
        System.out.println("Tokens that are not literal tokens should be replaced with the appropriate value.");
        System.out.println("");
        System.out.println("Tokens that are optional are enclosed in square brackets. If more than one token is");
        System.out.println("included and separated by a vertical bar, you can chose one or none of the tokens.");
        System.out.println("Neither the square brackets or vertical bars should be specified on the command.");
        System.out.println("");
        System.out.println("If there are multiple token choices but one is required, the tokens are enclosed in");
        System.out.println("braces and separated by a vertical bar.");
        System.out.println("Neither the braces or vertical bars should be specified on the command.");
        System.out.println("");
        System.out.println("If a token or group of tokens, grouped by square brackets or braces, can be repeated,");
        System.out.println("a sequence of three periods will follow the token or token group.");
    }

    Date getNotBefore() {
        return this.validFrom;
    }

    Date getNotAfter() {
        return this.validTill;
    }

    CertPrincipal getSubject() {
        return this.subject;
    }

    synchronized HashSet getAlternateDNSNames() {
        if (this.alternativeNames != null) {
            return this.alternativeNames.getDNSNames();
        }
        return new HashSet();
    }

    synchronized HashSet getIPAddresses() {
        if (this.alternativeNames != null) {
            return this.alternativeNames.getIPAddrNames();
        }
        return new HashSet();
    }

    private static void view(String fileName) throws HException, FileNotFoundException {
        X509Certificate cert = null;
        cert = CertUtils.createX509Certificate(fileName);
        System.out.println(cert.toString());
    }

    private synchronized void parse(X500Principal subjectDN) {
        String subject = null;
        StringTokenizer st = null;
        StringTokenizer st2 = null;
        String currentToken = null;
        String currentProperty = null;
        String currentValue = null;
        String country = null;
        String state = null;
        String locality = null;
        String org = null;
        String orgUnit = null;
        String hostName = null;
        String eMailAddr = null;
        Trace.trace(TRACE_MASKT, "->parse(" + subjectDN + ")");
        if (subjectDN != null && (subject = subjectDN.toString()) != null) {
            st = new StringTokenizer(subject, ",");
            while (st.hasMoreTokens()) {
                currentToken = st.nextToken().trim();
                Trace.trace(TRACE_MASKD, "property and value pair found of " + currentToken);
                st2 = new StringTokenizer(currentToken, "=");
                if (st2.countTokens() != 2) continue;
                currentProperty = st2.nextToken();
                Trace.trace(TRACE_MASKD, "property found of " + currentProperty);
                currentValue = st2.nextToken();
                Trace.trace(TRACE_MASKD, "value found of " + currentValue);
                if (currentProperty.equals("C")) {
                    country = currentValue;
                    continue;
                }
                if (currentProperty.equals("ST")) {
                    state = currentValue;
                    continue;
                }
                if (currentProperty.equals("L")) {
                    locality = currentValue;
                    continue;
                }
                if (currentProperty.equals("O")) {
                    org = currentValue;
                    continue;
                }
                if (currentProperty.equals("OU")) {
                    orgUnit = currentValue;
                    continue;
                }
                if (currentProperty.equals("CN")) {
                    hostName = currentValue;
                    continue;
                }
                if (currentProperty.equals("EMAILADDRESS")) {
                    eMailAddr = currentValue;
                    continue;
                }
                Trace.trace(TRACE_MASKD, "Unknown property of " + currentProperty + " and value of " + currentValue);
            }
            this.subject = new CertPrincipal(country, state, locality, org, orgUnit, hostName, eMailAddr);
        }
        Trace.trace(TRACE_MASKT, "<-parse(...)");
    }

    int getVersion() {
        return this.version;
    }

    BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    CertPrincipal getIssuerX500Principal() {
        return this.issuer;
    }

    Integer getNumOfDays() {
        return this.days;
    }

    SubjectAltNames getSubjectAltNames() {
        return this.alternativeNames;
    }

    synchronized void setSubjectAltNames(SubjectAltNames altNames) {
        this.alternativeNames = altNames;
    }

    synchronized void setNumOfDays(Integer numOfDays) {
        if (numOfDays == null) {
            throw new IllegalArgumentException("numOfDays can not be null.");
        }
        if (numOfDays < 1) {
            throw new IllegalArgumentException("numOfDays can not be less than 1: " + numOfDays);
        }
        this.days = numOfDays;
        this.validTill = null;
    }

    synchronized void setSubject(CertPrincipal subject) {
        if (subject == null) {
            throw new IllegalArgumentException("The subject was specified as null.");
        }
        this.subject = subject;
    }

    synchronized void setIssuer(CertPrincipal issuer) {
        if (issuer == null) {
            throw new IllegalArgumentException("The issuer was specified as null.");
        }
        this.issuer = issuer;
    }

    synchronized boolean isSelfSigned() {
        boolean result = false;
        if (this.subject != null && this.issuer != null && this.subject.equals(this.issuer)) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String writeToFile(String fileName, String serverKeyFile, boolean removePassPhrase) throws HException {
        CertSignReq csr = null;
        Object createCertCommand = null;
        int daysToUseOnCreate = 0;
        CertPrincipal tempSubject = null;
        String passPhrase = null;
        String tempCSRFileName = null;
        File tempCSRFile = null;
        String tempDir = null;
        if (this.isSelfSigned()) {
            tempDir = CertUtils.getConfiguredTempDir();
            try {
                try {
                    tempCSRFile = File.createTempFile(TRACE_MASKT, null, new File(tempDir));
                    tempCSRFileName = tempCSRFile.getCanonicalPath();
                }
                catch (IOException e) {
                    new FrameworkLog(CertMgtConstants.LOG_INFO, 12, e).log();
                    throw new HException(e);
                }
                tempSubject = this.getSubject();
                csr = new CertSignReq(tempSubject != null ? tempSubject.getCountry() : null, tempSubject != null ? tempSubject.getState() : null, tempSubject != null ? tempSubject.getLocality() : null, tempSubject != null ? tempSubject.getOrg() : null, tempSubject != null ? tempSubject.getOrgUnit() : null, tempSubject != null ? tempSubject.getHostName() : null, tempSubject != null ? tempSubject.getEMailAddr() : null, this.getAlternateDNSNames(), this.getIPAddresses());
                passPhrase = csr.writeToFile(tempCSRFileName, serverKeyFile, removePassPhrase, false);
                daysToUseOnCreate = this.days != null ? this.days : CertUtils.wholeDaysGreater(this.getNotAfter(), new Date()) + 1;
                csr.selfSign(tempCSRFileName, serverKeyFile, daysToUseOnCreate, this.isForCA, passPhrase, fileName, false);
                String string = passPhrase;
                return string;
            }
            finally {
                if (tempCSRFile != null) {
                    tempCSRFile.delete();
                }
            }
        }
        throw new HException("Server certificate can not be generated since it is not self-signed.");
    }

    public synchronized boolean equals(Object otherObject) {
        boolean result = false;
        ServerCert other = null;
        if (otherObject != null && otherObject instanceof ServerCert) {
            other = (ServerCert)otherObject;
            if ((this.days == null ? other.days == null : this.days.equals(other.days)) && (this.validFrom == null ? other.validFrom == null : this.validFrom.equals(other.validFrom)) && (this.validTill == null ? other.validTill == null : this.validTill.equals(other.validTill)) && (this.issuer == null ? other.issuer == null : this.issuer.equals(other.issuer)) && (this.subject == null ? other.subject == null : this.subject.equals(other.subject)) && (this.alternativeNames == null ? other.alternativeNames == null : this.alternativeNames.equals(other.alternativeNames)) && this.version == other.version && (this.serialNumber == null ? other.serialNumber == null : this.serialNumber.equals(other.serialNumber))) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public synchronized boolean equalsSomewhat(Object otherObject) {
        boolean result = false;
        ServerCert other = null;
        if (otherObject != null && otherObject instanceof ServerCert) {
            other = (ServerCert)otherObject;
            if ((this.issuer == null ? other.issuer == null : this.issuer.equals(other.issuer)) && (this.subject == null ? other.subject == null : this.subject.equals(other.subject)) && (this.alternativeNames == null ? other.alternativeNames == null : this.alternativeNames.equals(other.alternativeNames))) {
                result = true;
            }
        }
        return result;
    }

    public synchronized String toString() {
        StringBuffer result = null;
        result = new StringBuffer();
        CertUtils.appendPropertyValue("days", this.days != null ? this.days.toString() : "", result);
        CertUtils.appendPropertyValue("validFrom", this.validFrom != null ? new SimpleDateFormat().format(this.validFrom) : "", result);
        CertUtils.appendPropertyValue("validTill", this.validTill != null ? new SimpleDateFormat().format(this.validTill) : "", result);
        CertUtils.appendPropertyValue("issuer", this.issuer != null ? this.issuer.toString() : "", result);
        CertUtils.appendPropertyValue("subject", this.subject != null ? this.subject.toString() : "", result);
        CertUtils.appendPropertyValue("alternativeNames", this.alternativeNames != null ? this.alternativeNames.toString() : "", result);
        CertUtils.appendPropertyValue("version", this.version != -1 ? String.valueOf(this.version) : "", result);
        CertUtils.appendPropertyValue("serialNumber", this.serialNumber != null ? this.serialNumber.toString() : "", result);
        return result.toString();
    }

    synchronized void setHostName(String hostName) {
        if (this.isSelfSigned()) {
            this.issuer.setHostName(hostName);
        }
        this.subject.setHostName(hostName);
    }

    synchronized void addDNSName(String dNSName) {
        if (this.alternativeNames == null) {
            this.alternativeNames = new SubjectAltNames();
        }
        this.alternativeNames.addDNSName(dNSName);
    }

    synchronized void removeDNSName(String dNSName) {
        if (this.alternativeNames != null) {
            this.alternativeNames.removeDNSName(dNSName);
        }
    }

    synchronized void addIPAddr(String iPAddr) {
        if (this.alternativeNames == null) {
            this.alternativeNames = new SubjectAltNames();
        }
        this.alternativeNames.addIPAddrName(iPAddr);
    }

    synchronized void removeIPAddr(String iPAddr) {
        if (this.alternativeNames != null) {
            this.alternativeNames.removeIPAddrName(iPAddr);
        }
    }
}

